// Cursor // Radnen 2008 // Sphere v1.14 //

const CURSORS = [LoadImage("Cursor.png"), LoadImage("Cursor2.png")];

var Cursor = {}
Cursor.leftIdle = true;
Cursor.rightIdle = true;
Cursor.image = 0;
Cursor.x = GetScreenWidth() / 2;
Cursor.y = GetScreenHeight() / 2;

Cursor.draw = function()
{
	Cursor.x = GetMouseX();
	Cursor.y = GetMouseY();
	CURSORS[this.image].blit(this.x, this.y);
	if (IsMouseButtonPressed(MOUSE_LEFT)) this.image = 1;
	else this.image = 0;
}

Cursor.handleUnPress = function()
{
	if (!IsMouseButtonPressed(MOUSE_RIGHT)) this.rightIdle = true;
	if (!IsMouseButtonPressed(MOUSE_LEFT)) this.leftIdle = true;
}

Cursor.setXY = function(x, y)
{
	Cursor.x = x;
	Cursor.y = y;
	SetMousePosition(x, y);
}

function MoveMouse(newX, newY, msecs)
{
	var bg = GrabImage(0, 0, SW, SH);
	var x = GetMouseX(), y = GetMouseY();
	var xv = x, yv = y;
	var time = GetTime();
	while(time+msecs > GetTime())
	{
		bg.blit(0, 0);
		if (newX > x) xv = x + (GetTime() - time) * (newX-x) / msecs;
		if (newX < x) xv = x - (GetTime() - time) * (x-newX) / msecs;
		if (newY > y) yv = y + (GetTime() - time) * (newY-y) / msecs;
		if (newY < y) yv = y - (GetTime() - time) * (y-newY) / msecs;
		CURSORS[Cursor.image].blit(xv, yv);
		Cursor.setXY(xv, yv);
		FlipScreen();
	}
	bg.blit(0, 0);
	CURSORS[Cursor.image].blit(newX, newY);
	Cursor.setXY(newX, newY);
}